{
    This file is part of EKD500Control

    RFT EKD500 Control program

    Copyright (C) 2013-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.
}
unit unrx;

{$mode objfpc}

interface

uses
    Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
    StdCtrls, Spin;

type

    { TFNRX }

    TFNRX = class(TForm)
      Button1: TButton;
      SPNRX: TSpinEdit;
      procedure Button1Click(Sender: TObject);
    private
      { private declarations }
    public
      { public declarations }
    end;

var
    FNRX: TFNRX;

implementation

uses EKD500;

{ TFNRX }

procedure TFNRX.Button1Click(Sender: TObject);

var i: integer;

begin
  NumberOfReceivers := SPNRX.Value;
  EKD.CBREC.Clear;
  for i := 1 to NumberOfReceivers do EKD.CBREC.Add(IntTostr(i));
  EKD.SaveConfig;
  EKD.ReadConfig;
  FNRX.Hide;
end;

initialization
  {$I unrx.lrs}

end.

