{
    This file is part of EKD500Control

    RFT EKD500 Control program

    Copyright (C) 2014-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.

                                    * * *

    Hamlib rigctld-maybe-compatible EKD500 control net server.
    The strictly-networking part is in ekd500.pas using lNET.

    Rigctld commands are only partially coded. The implementation uses
    only the basic remote command capabilities of the EKD500.
    ==========================================================================
                                   WANTED
    ==========================================================================
             Someone with better knowledge of how rigctld works
                to help complete/correct the implementation.
    ==========================================================================
}

unit UState;

{$mode ObjFPC}

interface

uses
  Classes, SysUtils;

// This is a mix of what is returned by rigctld in response to the dump_state
// command for some other rigs since the EKD500 backend is largely incomplete,
// with some mods by trial and error

var EKD500_State: array of string = (
  '1',
  '24001',
  '0',
  '10000.000000 30000000.000000 0x31f -1 -1 0x1 0x0',
  '0 0 0 0 0 0 0',
  '0 0 0 0 0 0 0',
  '0x31f 10',
  '0 0',
  '0x200 6000',         // AM SYNCH Normal
  '0x200 6000',         // AM SYNCH Wide
  '0x200 3000',         // AM SYNCH Narrow
  '0x100 750',          // RTTYR Normal
  '0x100 1750',         // RTTYR Wide
  '0x100 400',          // RTTYR Narrow
  '0x10 750',           // RTTY Normal
  '0x10 1750',          // RTTY Wide
  '0x10 400',           // RTTY Narrow
  '0x08 -3000',         // LSB Normal
  '0x08 -3000',         // LSB Wide
  '0x08 -3000',         // LSB Narrow
  '0x04 3000',          // USB Normal
  '0x04 3000',          // USB Wide
  '0x04 3000',          // USB Narrow
  '0x02 400',           // CW Normal
  '0x02 750',           // CW Wide
  '0x02 150',           // CW Narrow
  '0x01 6000',          // AM Normal
  '0x01 6000',          // AM Wide
  '0x01 3100',          // AM Narrow
  '0 0',
  '0',
  '0',
  '8000',
  '0',
  '',
  '',
  '0x0',
  '0x0',
  '0x40020000',   // get_level: STRENGTH and AGC
  '0x20000',      // set_level: AGC
  '0x0',
  '0x0',
  'done'
);

implementation

end.


