{
    This file is part of EKD500Control

    RFT EKD500 Control program

    Copyright (C) 2014-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.
}

unit urename;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls;

type

  { TFNEWN }

  TFNEWN = class(TForm)
    BREN: TButton;
    BCANC: TButton;
    EDNEWN: TEdit;
    procedure BCANCClick(Sender: TObject);
    procedure BRENClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FNEWN: TFNEWN;

implementation

uses umanager;

{ TFNEWN }

procedure TFNEWN.BRENClick(Sender: TObject);

var oldname, newname: string;
begin
   oldname := UMGR.TFLB.Filename;
   newname := ExtractFilePath(oldname) + EDNEWN.Text;
   if RenameFile(oldname, newname) then begin
     FNEWN.Hide;
     UMGR.TFLB.UpdateFileList;
   end;
end;

procedure TFNEWN.BCANCClick(Sender: TObject);
begin
  FNEWN.Hide;
end;

initialization
  {$I urename.lrs}

end.

