{
    This file is part of RA1792Control

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units.

    Copyright (C) 2012-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.
}

unit umanager;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  FileCtrl, Buttons, StdCtrls, urename, ucopy;

type

  { TUMGR }

  TUMGR = class(TForm)
    BDONE: TButton;
    SPCOPY: TSpeedButton;
    SPDEL1: TSpeedButton;
    SPMOVE2CH: TSpeedButton;
    TFLB: TFileListBox;
    SPREN: TSpeedButton;
    SPMOVE2ST: TSpeedButton;
    procedure BDONEClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SPCOPYClick(Sender: TObject);
    procedure SPDELClick(Sender: TObject);
    procedure SPMOVEClick(Sender: TObject);
    procedure SPRENClick(Sender: TObject);
    procedure TFLBSelectionChange(Sender: TObject; User: boolean);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  UMGR: TUMGR;
  OH,OW,OFH: integer;

resourcestring
  AREUSURE = 'Are you sure?';
  DELEFILE = 'Delete file ''';

implementation

uses ura1792;

{ TUMGR }

procedure TUMGR.BDONEClick(Sender: TObject);
begin
  UMGR.Hide;
  if UMGR.Tag = 1 then
    ra1792.LoadChannelsDir;
end;

procedure TUMGR.FormActivate(Sender: TObject);
begin
  SPREN.Enabled := False;
  SPCOPY.Enabled := False;
  SPMOVE2ST.Enabled := False;
  SPMOVE2CH.Enabled := False;
end;

procedure TUMGR.FormCreate(Sender: TObject);
begin
    // Save starting width, height & font height
    OW := TFLB.Width;
    OH := TFLB.Height;
    OFH := TFLB.Font.Height;
end;

procedure TUMGR.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
    NewFontHeight := (OFH * FontMagn) div 100;
    TFLB.Font.Height := NewFontHeight;
    UMGR.Width := (OW * FontMagn) div 100;
    UMGR.Left := (Screen.Width-UMGR.Width) div 2;
    UMGR.Top := (Screen.Height-UMGR.Height) div 2;
end;

procedure TUMGR.SPCOPYClick(Sender: TObject);

begin
  FCOPY.EDCOPYN.Text := ExtractFileName(TFLB.Filename);
  FCOPY.Show;
end;

procedure TUMGR.SPDELClick(Sender: TObject);

var
  FileName: string;

begin
  FileName := TFLB.Filename;
  if (FileName <> '') and (MessageDlg(AREUSURE, DELEFILE +
    ExtractFileName(FileName) + '''?', mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
  begin
    DeleteFile(Filename);
    TFLB.UpdateFileList;
  end;
end;

procedure TUMGR.SPMOVEClick(Sender: TObject);

var FilePathName,FileName: string;

begin
  FilePathName := TFLB.Filename;
  FileName := ExtractFileName(FilePathName);
  if (FileName <> '') then begin
     if Sender = SPMOVE2CH then begin
        CopyFile(FilePathName,ChannelsDir+FileName);
        DeleteFile(FilePathName);
     end;
     if Sender = SPMOVE2ST then begin
        CopyFile(FilePathName,StateDir+Filename);
        DeleteFile(FilePathName);
     end;
  end;
  TFLB.UpdateFileList;
end;

procedure TUMGR.SPRENClick(Sender: TObject);

begin
  FNEWN.EDNEWN.Text := ExtractFileName(TFLB.Filename);
  FNEWN.Show;
end;

procedure TUMGR.TFLBSelectionChange(Sender: TObject; User: boolean);
begin
  SPREN.Enabled := True;
  SPCOPY.Enabled := True;
  SPMOVE2CH.Enabled := TRUE;
  SPMOVE2ST.Enabled := True;
end;

initialization
  {$I umanager.lrs}

end.
