{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2023 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                   * * *

    Allows entering the scan parameters and perform a frequency scan
}


unit ufrscan;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Spin, JFloatEdit;

type

  { TFFRSCAN }

  TFFRSCAN = class(TForm)
    BAPPLY: TButton;
    BCLOSE: TButton;
    BSTARTSTOPSCAN: TButton;
    CBCOR: TComboBox;
    CBDIR: TComboBox;
    FSPSTEP: TFloatSpinEdit;
    FSPSWRATE: TFloatSpinEdit;
    FSPSTART: TFloatSpinEdit;
    FSPSTOP: TFloatSpinEdit;
    LBCOR: TLabel;
    LBDIR: TLabel;
    LBCORL: TLabel;
    LBSTEP: TLabel;
    LBSWRATE: TLabel;
    LBSTOP: TLabel;
    LBSTART: TLabel;
    SPCORL: TSpinEdit;
    procedure BAPPLYClick(Sender: TObject);
    procedure BCLOSEClick(Sender: TObject);
    procedure BSTARTSTOPSCANClick(Sender: TObject);
    procedure CBCORChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FSPSTARTChange(Sender: TObject);
    procedure FSPSTEPChange(Sender: TObject);
    procedure FSPSTOPChange(Sender: TObject);
    procedure FSPSWRATEChange(Sender: TObject);
  private

  public

  end;

var
  FFRSCAN: TFFRSCAN;
  iStartFr, iStopFr, iStepFr: integer;

implementation

uses ura3701;

{ TFFRSCAN }

 // "Close" button
procedure TFFRSCAN.BCLOSEClick(Sender: TObject);
begin
  StartSc := FALSE;
  if RA3701.SendCommand(Set_Scan, '0,'+IntToStr(CBDIR.ItemIndex)) then begin
    if not RA3701.GetAck then RA3701.MsgToShow := NOACK+Status;
  end else RA3701.MsgToShow := COMMANDFAILED;
  FFRSCAN.Hide;
  KeyboardState := STATE_NORMAL;
  if RA3701.MRESTSTATE.Checked then begin
    // Restore old state after scan.
    // If not checked, RX stays at frequency&mode of the last channel scanned
    RXState := OldRXState;
    RA3701.RestoreState;
  end;
  RA3701.GetStatus;
  RA3701.ParseStatus;
  RA3701.SetActiveButtons;
  RA3701.UpdateDisplay;
end;

// "Start scan" or "Stop scan" button
procedure TFFRSCAN.BSTARTSTOPSCANClick(Sender: TObject);

var Dir: string;

begin
  StartSc := NOT StartSc;
  LBCOR.Enabled := TRUE;
  RA3701.LBScan.Visible := StartSc;
  if In_Command then exit;
  In_Command := TRUE;
  Dir := IntToStr(CBDIR.ItemIndex);
  if StartSc then begin
    KeyboardState := STATE_SCAN;
    if RA3701.SendCommand(Set_Scan, '1,'+Dir) then begin
      if not RA3701.GetAck then RA3701.MsgToShow := NOACK;
    end else RA3701.MsgToShow := COMMANDFAILED;
    BSTARTSTOPSCAN.Caption := STOPSCAN;
  end else begin
    if RA3701.SendCommand(Set_Scan, '0,'+Dir) then begin
      if not RA3701.GetAck then RA3701.MsgToShow := NOACK;
    end else RA3701.MsgToShow := COMMANDFAILED;
    BSTARTSTOPSCAN.Caption := STARTSCAN;
  end;
end;

//
// Handles modifications to scan values
//

procedure TFFRSCAN.CBCORChange(Sender: TObject);
begin
  if CBCOR.ItemIndex = 0 then begin
    LBCORL.Enabled := FALSE;
    SPCORL.Enabled := FALSE;
  end else begin
    LBCORL.Enabled := TRUE;
    SPCORL.Enabled := TRUE;
  end;
  BSTARTSTOPSCAN.Hide;
end;


// Set controls caption text and enable status
procedure TFFRSCAN.FormShow(Sender: TObject);
begin
  FFRSCAN.Caption := ENTERSCANPARMS;
  BSTARTSTOPSCAN.Caption := STARTSCAN;
  BAPPLY.Caption := APPLY;
  BCLOSE.Caption := CLOSEW;
  LBSTART.Caption := FREQSTART;
  LBSTOP.Caption := FREQSTOP;
  LBSTEP.Caption := FREQSTEP;
  LBSWRATE.Caption := SWRATE;
  LBCOR.Caption := CORCONTROL;
  LBCORL.Caption := CORLEVEL;
  LBDIR.Caption := DIRECT;
  BSTARTSTOPSCAN.Hide;
  if CBCOR.ItemIndex = 0 then begin
    LBCORL.Enabled := FALSE;
    SPCORL.Enabled := FALSE;
  end else begin
    LBCORL.Enabled := TRUE;
    SPCORL.Enabled := TRUE;
  end;
  StartSc := FALSE;
end;

procedure TFFRSCAN.FSPSTARTChange(Sender: TObject);
begin
  FSPSTART.Font.Color := clBlack;  // clear error, if any
  BSTARTSTOPSCAN.Hide;
end;

procedure TFFRSCAN.FSPSTEPChange(Sender: TObject);
begin
  FSPSTART.Font.Color := clBlack;  // clear error, if any
  BSTARTSTOPSCAN.Hide;
end;

procedure TFFRSCAN.FSPSTOPChange(Sender: TObject);
begin
  FSPSTOP.Font.Color := clBlack;  // clear error, if any
  BSTARTSTOPSCAN.Hide;
end;

procedure TFFRSCAN.FSPSWRATEChange(Sender: TObject);
begin
  FSPSTART.Font.Color := clBlack;  // clear error, if any
  BSTARTSTOPSCAN.Hide;
end;

// Check parameters and if OK apply them
procedure TFFRSCAN.BAPPLYClick(Sender: TObject);

var cor,par: string;
    Parms_OK: boolean;
    StartFr: Double;

begin
  Parms_OK := TRUE;
  if (FSPSTART.Value >= FSPSTOP.Value) then begin
    FSPSTART.Font.Color := clRED;
    Parms_OK := FALSE;
    FSPSTOP.Font.Color := clRED;
    Parms_OK := FALSE;
  end;

  if Parms_OK then begin
    if In_Command then exit;
    In_Command := TRUE;
    cor := IntToStr(CBCOR.ItemIndex);
    par := Format('%5.3fK,%5.3fK,%3.1fK,%3.2fK,%s;',
           [FSPSTART.Value,FSPSTOP.Value, FSPSTEP.Value, FSPSWRATE.Value,cor]);
    if RA3701.SendCommand(Set_FrSwParms, par) then begin
        if not RA3701.GetAck then RA3701.MsgToShow := NOACK;
    end else RA3701.MsgToShow := COMMANDFAILED;
    In_Command := FALSE;
    BSTARTSTOPSCAN.Caption := STARTSCAN;
    BSTARTSTOPSCAN.Show;
  end;
end;

initialization
  {$I ufrscan.lrs}

end.

