{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units. The CU
    firmware version can be either 80R or 92.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Rename a file
}

unit urename;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, DefaultTranslator;

type

  { TFNEWN }

  TFNEWN = class(TForm)
    BREN: TButton;
    BCANC: TButton;
    EDNEWN: TEdit;
    procedure BCANCClick(Sender: TObject);
    procedure BRENClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FNEWN: TFNEWN;
  OH, OW, OFH: integer;

resourcestring
  RENAMEFAILED = 'Rename failed';

implementation

uses umanager, skanti;

  { TFNEWN }

// Rename a file
procedure TFNEWN.BRENClick(Sender: TObject);
var
  oldname, newname: string;
begin
  oldname := UMGR.TFLB.Filename;
  newname := ExtractFilePath(oldname) + EDNEWN.Text;
  if RenameFile(oldname, newname) then
  begin
    FNEWN.Hide;
    UMGR.TFLB.UpdateFileList;
  end else
    ShowMessage(RENAMEFAILED);
end;

// Things to do at startup
procedure TFNEWN.FormCreate(Sender: TObject);
begin
  // Save starting width, height & font height
  OW := FNEWN.Width;
  OH := FNEWN.Height;
  OFH := EDNEWN.Font.Height;
end;

// Things to do when the form is shown
procedure TFNEWN.FormShow(Sender: TObject);
var
  NewFontHeight: integer;
begin
  NewFontHeight := (OFH * FontMagn) div 100;
  EDNEWN.Font.Height := NewFontHeight;
  FNEWN.Height := (OH * FontMagn) div 100;
  FNEWN.Width := (OW * FontMagn) div 100;
  FNEWN.Top := (Screen.Height - FNEWN.Height) div 2;
  FNEWN.Left := (Screen.Width - FNEWN.Width) div 2;
end;

// Cancel button handling
procedure TFNEWN.BCANCClick(Sender: TObject);
begin
  FNEWN.Hide;
  UMGR.TFLB.ClearSelection;
end;

initialization
  {$I urename.lrs}

end.
